
<?php
$base = dirname(__FILE__);
$project_base = dirname(dirname(__FILE__));

error_reporting(E_ALL);
ini_set('display_errors', 'on');
ini_set('display_startip_errors', 'on');

// Load Composer
include('vendor/autoload.php');

// Load .env
$dotenv = Dotenv\Dotenv::createImmutable($base.'/../');
$dotenv->load(true);

// Payline sdk
use Payline\PaylineSDK;


define('SYSTEM_PATH',$_ENV['SYSTEM_PATH']);
define('DB_PREFIX',$_ENV['DB_PREFIX']);


// Check if storage folder exists
$path = '../storage/images';
if (!is_dir($path)) mkdir($path, 0775, true);

$path = '../storage/images_paid';
if (!is_dir($path)) mkdir($path, 0775, true);

$path = '../storage/invoices';
if (!is_dir($path)) mkdir($path, 0775, true);

/* include files */
require_once($base.'/backend/debugging_tools.php');
require_once($base.'/backend/error_handler.php');
require_once($base.'/backend/database.php');

$mysql_credentials = [
    'HOST' =>  $_ENV['DB_HOST'],
    'DATABASE' =>  $_ENV['DB_DATABASE'],
    'USER' =>  $_ENV['DB_USERNAME'],
    'PASSWORD' =>  $_ENV['DB_PASSWORD'],
];

/* start error handler */
$error_handler = new de_error_handler($mysql_credentials);

function validateToken($token)
{
    global $mysql_credentials;
    $db = new database($mysql_credentials);
    $db->connect();
    $data = $db->prepare('SELECT * FROM '.DB_PREFIX.'Token WHERE token=:token && used IS NULL;');
    $data->bindParam(':token', $token, PDO::PARAM_STR);
    $data->execute();
    $token_valid = $data->fetch(PDO::FETCH_ASSOC);
    if(!$token_valid) return;
    return $token_valid;
}

function getPaylineWebPaymentRequest($customer_reference,$forename,$surname,$email)
{
    //https://docs.monext.fr/display/DT/PW+-+Widget+Integration

    $proxy_host= null;
    $proxy_port = null;
    $proxy_login = null;
    $proxy_password = null;
    $pathLog= null;

    // create an instance
    $paylineSDK = new PaylineSDK($_ENV['PAYLINE_MERCHAND_ID'],$_ENV['PAYLINE_ACCESS_KEY'], $proxy_host, $proxy_port, $proxy_login, $proxy_password, $_ENV['PAYLINE_ENVIRONMENT']);

    // call a web service, for example doWebPayment
    $doWebPaymentRequest = array();
    $doWebPaymentRequest['version']  = $_ENV['PAYLINE_VERSION'];
    $doWebPaymentRequest['cancelURL'] = "https://".$_ENV['DOMAIN_NAME'].'/payline_cancel';
    $doWebPaymentRequest['returnURL'] = "https://".$_ENV['DOMAIN_NAME'].'/payline_return';
    $doWebPaymentRequest['notificationURL'] = "https://".$_ENV['DOMAIN_NAME'].'/payline_notification';

    // PAYMENT
	$doWebPaymentRequest['payment']['amount'] = $_ENV['PRODUCT_PRICE']; // this value has to be an integer amount is sent in cents
	$doWebPaymentRequest['payment']['currency'] = 978; // ISO 4217 code for euro
	$doWebPaymentRequest['payment']['action'] = 101; // 101 stand for "authorization+capture"
	$doWebPaymentRequest['payment']['mode'] = 'CPT'; // one shot payment

    // BUYER
    $doWebPaymentRequest['buyer']['firstName'] = $forename;
    $doWebPaymentRequest['buyer']['lastName'] = $surname;
    $doWebPaymentRequest['buyer']['email'] = $email;

	// ORDER
	$doWebPaymentRequest['order']['ref'] = $customer_reference; // the reference of your order
	$doWebPaymentRequest['order']['amount'] = $_ENV['PRODUCT_PRICE']; // may differ from payment.amount if currency is different
	$doWebPaymentRequest['order']['currency'] = 978; // ISO 4217 code for euro
    $doWebPaymentRequest['order']['date'] = date("d/m/Y H:i");

	// CONTRACT NUMBERS
	$doWebPaymentRequest['payment']['contractNumber'] = $_ENV['PAYLINE_CONTRACT_NUMBER'];
    $doWebPaymentRequest['contracts'] = array($_ENV['PAYLINE_CONTRACT_NUMBER']);

    return $paylineSDK->doWebPayment($doWebPaymentRequest);

}

function getPaylineWebPaymentDetails($token)
{
    $proxy_host= null;
    $proxy_port = null;
    $proxy_login = null;
    $proxy_password = null;
    $pathLog= null;

    // create an instance
    $paylineSDK = new PaylineSDK($_ENV['PAYLINE_MERCHAND_ID'],$_ENV['PAYLINE_ACCESS_KEY'], $proxy_host, $proxy_port, $proxy_login, $proxy_password, $_ENV['PAYLINE_ENVIRONMENT']);

    $array['token'] = $token;
    $array['version'] = "20";

    $responseToken = $paylineSDK->getWebPaymentDetails($array);
    //var_dump($responseToken);
    if($responseToken['result']['code'] != "00000") return;
    $order_id = explode("ID:",$responseToken['order']['ref'])[1];
    return updateOrderToPaid($order_id,$responseToken['transaction']['id']);
}

function updateOrderToPaid($order_id,$payline_transaction_id)
{
    global $mysql_credentials;
    $db = new database($mysql_credentials);
    $db->connect();
    $data = $db->prepare("UPDATE ".DB_PREFIX."Order SET order_status=1, payline_transaction_id=:payline_transaction_id WHERE order_id=:id LIMIT 1;");
    $data->bindParam(":payline_transaction_id", $payline_transaction_id, PDO::PARAM_STR);
    $data->bindParam(":id", $order_id, PDO::PARAM_STR);
    if($data->execute()) return true;
    return;
}

?>
