<?PHP
	class database extends PDO {
		
		protected $db_name;
		protected $db_user;
		protected $db_pass;
		protected $db_host;
		
		public function __construct($connection_data) {
			$this->db_name = $connection_data["DATABASE"];
			$this->db_user = $connection_data["USER"];
			$this->db_pass = $connection_data["PASSWORD"];
			$this->db_host = $connection_data["HOST"];
		}
		
		public function connect() {
			try {
				parent::__construct("mysql:host={$this->db_host};dbname={$this->db_name}", $this->db_user, $this->db_pass);
				parent::exec("SET CHARACTER SET utf8");

				parent::setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 
			} catch (PDOException $error) {
				error($error->getMessage(), __CLASS__ , __FUNCTION__);
			}
		}

	}
?>