<?PHP

	/**
	 * Reception Class
	 * Notiert die Aktivitäten der Nutzer
	 * 
	 * 
	 */
	class de_reception
	{
		private $db_connection;
		private $requested_uri;

		public function __construct ($db_connection, string $requested_uri)
		{
			$this->db_connection = $db_connection;
			$this->requested_uri = $requested_uri;
			$this->_track_visitor();
		}

		private function _track_visitor ()
		{
			$visitor_ip = get_real_ip_address();
			$timestamp = get_timestamp();
			//Benutzernamen in dB Suchen
			$data = $this->db_connection->prepare("SELECT * FROM ".DB_PREFIX."Visitors WHERE ip=:visitor_ip;");			
			$data->bindParam(":visitor_ip", $visitor_ip, PDO::PARAM_STR);
			$data->execute();
			$visitor = $data->fetch();			 
			$row_affected = $data->rowCount();
			$uris = array();
			$cur_uri = array($timestamp, $this->requested_uri);

			
			if($row_affected == 0)
			{
				$data = $this->db_connection->prepare("INSERT INTO ".DB_PREFIX."Visitors SET last_interaction=:timestamp, clicks=1, created=:timestamp, requested_uris=:json_uris, ip=:visitor_ip;");	
			}
			else
			{				
				$data = $this->db_connection->prepare("UPDATE ".DB_PREFIX."Visitors SET last_interaction=:timestamp, clicks=clicks+1, requested_uris=:json_uris WHERE ip=:visitor_ip");
				$uris= json_decode($visitor["requested_uris"]);			
			}	
			$uris[] = $cur_uri;
			$json_uris = json_encode($uris);
			
			$data->bindParam(":timestamp", $timestamp, PDO::PARAM_STR);
			$data->bindParam(":json_uris", $json_uris, PDO::PARAM_STR);
			$data->bindParam(":visitor_ip", $visitor_ip, PDO::PARAM_STR);
			$data->execute();
		}	
	}
	
?>