<?php

$base = dirname(__FILE__);
$project_base = dirname(dirname(__FILE__));

error_reporting(E_ALL);
ini_set('display_errors', 'on');
ini_set('display_startip_errors', 'on');

// Load Composer
include('vendor/autoload.php');

// Load .env
$dotenv = Dotenv\Dotenv::createImmutable($base.'/../');
$dotenv->load(true);

// Payline sdk
use Payline\PaylineSDK;

define('SYSTEM_PATH',$_ENV['SYSTEM_PATH']);
define('DB_PREFIX',$_ENV['DB_PREFIX']);

// Check if storage folder exists
$path = $base.'/../storage/images';
if (!is_dir($path)) mkdir($path, 0775, true);

$path = $base.'/../storage/images_paid';
if (!is_dir($path)) mkdir($path, 0775, true);

$path = $base.'/../storage/invoices';
if (!is_dir($path)) mkdir($path, 0775, true);

/* include files */
require_once($base.'/backend/debugging_tools.php');
require_once($base.'/backend/error_handler.php');
require_once($base.'/backend/database.php');

$mysql_credentials = [
    'HOST' =>  $_ENV['DB_HOST'],
    'DATABASE' =>  $_ENV['DB_DATABASE'],
    'USER' =>  $_ENV['DB_USERNAME'],
    'PASSWORD' =>  $_ENV['DB_PASSWORD'],
];

require 'PHPMailer/class.phpmailer.php';
require 'PHPMailer/class.smtp.php';

//require 'invoice.php';

/* start error handler */
$error_handler = new de_error_handler($mysql_credentials);

/* config */
$max_mails = 10;

$log = "";
$error = "";

/* establish mysql connection */
$db = new database($mysql_credentials);
$db->connect();

/* search for order in db */
$data = $db->prepare("SELECT * FROM ".DB_PREFIX."Order WHERE order_status=1;");
$data->execute();
$order_data = $data->fetchAll();

$sent_mails = 0;
NOTICE("Cronjob called at:".date('Y-m-d H:i:s')." ".count($order_data)." order(s) in queue");
/* loop trough orders */
foreach($order_data as $order)
{
	/* limit mails to send per execution */
	if($sent_mails < $max_mails)
	{

		/* image_url */
		$image_url = dirname(__FILE__) ."/../storage/images/".$order["imagefile"];

		if(file_exists($image_url))
		{

			if(filter_var($order["email"], FILTER_VALIDATE_EMAIL))
			{
				/*
                // Select highest invoice number
                $data = $db->prepare("SELECT order_id, invoice_id FROM ".DB_PREFIX."Order WHERE invoice_id = (SELECT MAX(invoice_id) FROM DE_deOrder);");
                $data->execute();
                $highest_invoice_id = $data->fetch(PDO::FETCH_ASSOC);
				//echo $highest_invoice_id['order_id']." == ".$order['order_id']."<br>";

                //If no invoice exists start from 1
                $new_invoice_id = $highest_invoice_id['invoice_id']==null ? "1" : $highest_invoice_id['invoice_id']+1;

                // Attach new invoice number to current order
				if($order['invoice_id'] == null) // Check if invoice number was already created
				{
	                $data = $db->prepare("UPDATE ".DB_PREFIX."Order SET invoice_id=:new_invoice_id WHERE order_id=:id LIMIT 1;");
	                $data->bindParam(":id", $order['order_id'], PDO::PARAM_STR);
	                $data->bindParam(":new_invoice_id", $new_invoice_id, PDO::PARAM_STR);
					$data->execute();
				}
                // Get new invoice number with zerofill
                $data = $db->prepare("SELECT invoice_id FROM ".DB_PREFIX."Order WHERE order_id=:id LIMIT 1;");
                $data->bindParam(":id", $order['order_id'], PDO::PARAM_STR);
                $data->execute();
                $new_invoice_id_zerofill = $data->fetch(PDO::FETCH_ASSOC)["invoice_id"];
				$new_invoice_id_zerofill_pref = $crm_config['CRM']['INVOICE_PREFIX'].$new_invoice_id_zerofill;
				$order_id_pref = $crm_config['CRM']['ORDER_PREFIX'].$order["order_id"];
                $invoice_url =  dirname(__FILE__) ."/../storage/invoices/".date("Y-m-d_H-i-s")."_INVOICE_".preg_replace("/[^a-zA-Z0-9]+/", "", $order["forename"])."-".preg_replace("/[^a-zA-Z0-9]+/", "", $order["surname"]).".pdf";

                // Generate Invoce
                generate_invoice($order["forename"],$order["surname"],$order["street"],$order["zipcity"],$order_id_pref,$new_invoice_id_zerofill_pref,$invoice_url);
*/
				$image_url_paid = dirname(__FILE__) ."/../storage/images_paid/".$order["imagefile"];


				/* Put order/invoice id and name to image*/
				copy($image_url,$image_url_paid);
				saveImageWithText($order['forename']." ".$order['surname']." ".$order['order_id'], $_ENV["PRIMARY_THEME_COLOR"], $_ENV["SECONDARY_THEME_COLOR"], $image_url_paid);
				if (send_invoice_mail($order["forename"],$order["surname"],$order["street"],$order["zipcity"],$order["email"], $order['order_id'] /*,$new_invoice_id_zerofill_pref,$invoice_url*/) /*&&
                send_order_mail($order["forename"],$order["surname"],$order["street"],$order["zipcity"],$order["email"],$order_id_pref,$new_invoice_id_zerofill_pref,$invoice_url,$image_url)*/
                )
				{
					$data = $db->prepare("UPDATE ".DB_PREFIX."Order SET order_status=2 WHERE order_id=:id LIMIT 1;");
					$data->bindParam(":id", $order['order_id'], PDO::PARAM_STR);
					$data->execute();

					$log = "Mail for order ".$order["order_id"]." sent sucessfully to ".$order["email"];
					NOTICE($log);
					$sent_mails++;
				}
				else
				{
					$error = "Mail for ID ".$order["order_id"]." could not be sent";
					ERROR($error);
				}

			} else {
				$data = $db->prepare("UPDATE ".DB_PREFIX."Order SET order_status=3 WHERE order_id=:id LIMIT 1;");
				$data->bindParam(":id", $order['order_id'], PDO::PARAM_STR);
				$data->execute();

				$log = "Mail for order ".$order["order_id"]." empty or not vaild ".@$order["mail"];
				WARNING($log);
			}

		} else {
			$data = $db->prepare("UPDATE ".DB_PREFIX."Order SET order_status=4 WHERE order_id=:id LIMIT 1;");
			$data->bindParam(":id", $order['order_id'], PDO::PARAM_STR);
			$data->execute();
			$error = "Image not found in this place (".$image_url.")";
			ERROR($error);
		}
	}
}
echo $error;
echo "\n\n";
echo $log;

function send_invoice_mail($forename, $surname, $street, $zipcity, $email, $order_id /*, $invoice_id, $invoice_url*/)
{
    /* Setup PHPMailer Client */
    $mail = new PHPMailer();
    $mail->IsSMTP();
    $mail->Host       = $_ENV['MAIL_HOST'];
    $mail->SMTPDebug  = 0; // Kann man zu debug Zwecken aktivieren
    $mail->SMTPAuth   = true;
    $mail->Username   = $_ENV['MAIL_USERNAME'];
    $mail->Password   = $_ENV['MAIL_PASSWORD'];
    $mail->SMTPSecure = $_ENV['MAIL_ENCRYPTION'];        // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
    $mail->Port       = $_ENV['MAIL_PORT'];

    $frommail = $_ENV['MAIL_FROM_ADDRESS'];
    $fromname = $_ENV['MAIL_FROM_NAME'];
    $mail->SetFrom($frommail, $fromname);

    $mail->AddAddress($email, $forename." ".$surname);

    $mail->Subject = "votre commande Mission Espectad'or de l'usap #".$order_id;
    $mail->isHTML( true );
    $mail->CharSet = "UTF-8";

$mail->Body = "
Merci d'avoir commandé une silhouette pour la Mission Espectad'Or au stade Aimé Giral.<br><br>
\r\n
Elle sera installée dans les tribunes du stade dès le prochain match à domicile et y restera jusqu'à que nous puissions tous y retourner !<br><br>
\r\n
Notez bien votre numéro de commande : <b>".$order_id."</b><br><br>
\r\n
Il vous servira pour vous retrouvez dans les photos des tribunes que vous pourrez bientôt retrouver sur notre site usap.fr<br><br>
\r\n
Allez l'USAP !<br><br>
\r\n";

//$mail->AddAttachment($invoice_url);


    if(!$mail->Send()) {
        warning($mail->ErrorInfo);
      return false;
    } else {
      return true;
    }
}
/*
function send_order_mail($forename, $surname, $street, $zipcity, $email, $order_id, $invoice_id, $invoice_url,$image_url)
{

	// Setup PHPMailer Client
    $mail = new PHPMailer();
    $mail->IsSMTP();
    $mail->Host       = $_ENV['MAIL_HOST'];
    $mail->SMTPDebug  = 0; // Kann man zu debug Zwecken aktivieren
    $mail->SMTPAuth   = true;
    $mail->Username   = $_ENV['MAIL_USERNAME'];
    $mail->Password   = $_ENV['MAIL_PASSWORD'];
    $mail->SMTPSecure = $_ENV['MAIL_ENCRYPTION'];        // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
    $mail->Port       = $_ENV['MAIL_PORT'];

    $frommail = $_ENV['MAIL_MAIL'];
    $fromname = $_ENV['MAIL_FROM_NAME'];
    $mail->SetFrom($frommail, $fromname);

    $mail->AddAddress($_ENV['MAIL_ADRESS'], "TEAM");

    $mail->Subject = "Bestellung: ".$order_id."/".$invoice_id. " von ".$forename." ".$surname ;
    $mail->isHTML( true );
    $mail->CharSet = "UTF-8";
    $mail->Body =
        "Liebes Team,<br><br>
  \r\n
      hier ist eine Bestellung!<br><br>
  \r\n
      Name:  ".$forename." ".$surname."<br>
  \r\n
      Email:  ".$email."<br>
  \r\n
      Strasse:  ".$street."<br>
  \r\n
  PLZ, Ort:  ".$zipcity."<br>
\r\n
  Auftragsnummer: ".$order_id."<br>
  \r\n
  Rechnungsnummer: ".$invoice_id."<br>
  \r\n";

$mail->AddAttachment($image_url);
$mail->AddAttachment($invoice_url);


    if(!$mail->Send()) {
        warning($mail->ErrorInfo);
      return false;
    } else {
      return true;
    }
}
*/
function saveImageWithText($text, $text_color, $bg_color, $image_file) {

  $public_file_path = '.';

  // Copy and resample the imag
  list($width, $height) = getimagesize($image_file);
  $image_p = imagecreatetruecolor($width, $height);
  $image = imagecreatefromjpeg($image_file);
  imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width, $height);

  // Prepare font size and colors
  $text_color = hexColorAllocate($image_p, $text_color);
  $bg_color = hexColorAllocate($image_p, $bg_color);
  $font = dirname(__FILE__).'/arial.ttf';
  $font_size = 30;

  // Set the offset x and y for the text position
  $padding_x = 30;
  $padding_y = 20;

  $margin_x = 40;
  $margin_y = 120;

  // Get the size of the text area
  $dims = imagettfbbox($font_size, 0, $font, $text);
  $text_width = $dims[4] - $dims[6];
  $text_height = $dims[3] - $dims[5];
  $box_width = $text_width+($padding_x);

  // Add text background
  imagefilledrectangle($image_p, ($width-$box_width)/2+$padding_x, $height-$text_height-$padding_y-$margin_y, ($width+$box_width)/2+$padding_x, $height+$padding_y-$margin_y, $bg_color);

  // Add text
  imagettftext($image_p, $font_size, 0, ($width-$text_width)/2+$padding_x, $height-$margin_y, $text_color, $font, $text);

  // Save the picture
  imagejpeg($image_p, $image_file, 100);

  // Clear
  imagedestroy($image);
  imagedestroy($image_p);
};

function hexColorAllocate($im,$hex){
    $hex = ltrim($hex,'#');
    $a = hexdec(substr($hex,0,2));
    $b = hexdec(substr($hex,2,2));
    $c = hexdec(substr($hex,4,2));
    return imagecolorallocate($im, $a, $b, $c);
}


?>
