'use strict';

const image_width = 1361;
const image_height = 2254;
const image_ratio = image_height/image_width;
const mask_ratio = image_ratio;

const canvas = window.canvas = document.querySelector('canvas');
canvas.width = image_width;
canvas.height = image_height;

const video =  document.querySelector('video');
const mask =  document.querySelector('.mask');
var takePhotoButton;
var toggleFullScreenButton;
var switchCameraButton;
var currentFacingMode = 'user';
var angle;

function init_payment_view(order_data)
{

    const payline_frame = '<div id="PaylineWidget" data-token="'+order_data.payline_token+'" data-template="column" data-embeddedredirectionallowed="false" />';
     document.getElementById('payline-container').innerHTML = payline_frame //console.log(order_data);
     load_jsscript("https://homologation-payment.cdn.payline.com/cdn/scripts/widget-min.js");

    $('#viewCarousel').carousel('next');

}

function init_liveview()
{

    $("body").scrollTop();


    DetectRTC.load(function() {
    if (DetectRTC.isWebRTCSupported == false) {
        alert(
        "Merci d'utiliser Chrome, Firefox, iOS 11, Android 5 ou ultérieur, Safari 11 ou ultérieur",
        );
    } else {

        $('#viewCarousel').carousel('pause');
        initCameraUI();
        initCameraStream();

    //}
    }

    });

}

function initCameraUI() {

  takePhotoButton = document.getElementById('takePhotoButton');
  switchCameraButton = document.getElementById('switchCameraButton');

  takePhotoButton.addEventListener('click', function() {
    takeSnapshot();
  });

  // -- switch camera part
  if (DetectRTC.isMobileDevice || detectmobilebrowser()) {
  //if (DetectRTC.isMobileDevice) {
    switchCameraButton.style.display = 'block';

    switchCameraButton.addEventListener('click', function() {
      if (currentFacingMode === 'environment')
      {
          currentFacingMode = 'user';
          $("#video").addClass("userview");
      }
      else
      {
          currentFacingMode = 'environment';
          $("#video").removeClass("userview");

      }
      initCameraStream();
    });
  }  else {
        $("#video").addClass("userview");
    }

  // Listen for orientation changes to make sure buttons stay at the side of the
  // physical (and virtual) buttons (opposite of camera) most of the layout change is done by CSS media queries
  // https://www.sitepoint.com/introducing-screen-orientation-api/
  // https://developer.mozilla.org/en-US/docs/Web/API/Screen/orientation
  window.addEventListener(
    'orientationchange',
    function() {
      // iOS doesn't have screen.orientation, so fallback to window.orientation.
      // screen.orientation will
      if (screen.orientation) angle = screen.orientation.angle;
      else angle = window.orientation;

      var guiControls = document.getElementById('gui_controls').classList;
      var vidContainer = document.getElementById('vid_container').classList;

      if (angle == 270 || angle == -90) {
        guiControls.add('left');
        vidContainer.add('left');
      } else {
        if (guiControls.contains('left')) guiControls.remove('left');
        if (vidContainer.contains('left')) vidContainer.remove('left');
      }
      if($(".slide-liveview").hasClass('active'))
      {
      initCameraStream();
      }
      //0   portrait-primary
      //180 portrait-secondary device is down under
      //90  landscape-primary  buttons at the right
      //270 landscape-secondary buttons at the left
    },
    false,
  );
}

// https://github.com/webrtc/samples/blob/gh-pages/src/content/devices/input-output/js/main.js
function initCameraStream() {
  // stop any active streams in the window
  if (window.stream) {
    window.stream.getTracks().forEach(function(track) {
      track.stop();
    });
  }

var constraints = null;
if(DetectRTC.browser.isChrome && DetectRTC.isMobileDevice)
{
/*  constraints = {
    audio: false,
    video: {
        facingMode: currentFacingMode,
    }
};*/

constraints = {
  audio: false,
  video: {
      width:{ideal: 1920},
      height:{ideal: 1080},
      facingMode: currentFacingMode,
  }
};
}
else
{

    constraints = {
      audio: false,
      video: {
        //width: { ideal: size },
        //height: { ideal: size },
        width: { min: 720, ideal: 3840, max: 4000 },
        height: { min: 720, ideal: 2160, max: 4000 },
        facingMode: currentFacingMode,
      },
    };
}
  navigator.mediaDevices
    .getUserMedia(constraints)
    .then(handleSuccess)
    .catch(handleError);

  function handleSuccess(stream) {

    window.stream = stream; // make stream available to browser console
    video.srcObject = stream;

    //const video_track = window.stream.getVideoTracks()[0];
    //const video_settings = video_track.getSettings();
    video.onplaying = function() {
        calculate_liveview();

    };


    if (constraints.video.facingMode) {
      if (constraints.video.facingMode === 'environment') {
        switchCameraButton.setAttribute('aria-pressed', true);

      } else {
        switchCameraButton.setAttribute('aria-pressed', false);
        $("#video").addClass("userview");
      }
    }
    if($(".slide-liveview.active").length == 0)
    {
          $('#viewCarousel').carousel('next');
    }


  }

  function handleError(error) {
    console.log(error);
    alert("Vous devez autoriser l'accès à votre caméra. L'application va maintenant se recharger. Veuillez recommencer au début !");
    location.reload();
  }
}
function getCanvasBlob(canvas) {
  return new Promise(function(resolve, reject) {
    canvas.toBlob(function(blob) {
      resolve(blob);
    }, 'image/jpeg');
  });
}

function takeSnapshot() {
  //canvas.width = video.videoWidth;
  //canvas.height = video.videoHeight;
 var videoTargetWidth, videoTargetHeight, videoTargetPositionX, videoTargetPositionY;

if(video.videoHeight/video.videoWidth < image_ratio)
{
    videoTargetWidth = video.videoWidth/video.videoHeight*image_height;
    videoTargetPositionX = (image_width-videoTargetWidth)/2;
    videoTargetHeight = image_height;
    videoTargetPositionY = 0;
}
else {
    videoTargetHeight = video.videoHeight/video.videoWidth*image_width;
    videoTargetPositionY = (image_height-videoTargetHeight)/2;
    videoTargetWidth = image_width;
    videoTargetPositionX = 0;
}
//console.log(videoTargetPositionX+", "+videoTargetPositionY+", "+videoTargetWidth+", "+videoTargetHeight);
  canvas.getContext('2d').clearRect(0, 0, canvas.width, canvas.height);
  canvas.getContext('2d').drawImage(video, videoTargetPositionX, videoTargetPositionY, videoTargetWidth, videoTargetHeight,);
  canvas.getContext('2d').drawImage(mask, 0, 0, canvas.width, canvas.height);

  $('#viewCarousel').carousel('next');

}

function validate_form()
{

    if(/*grecaptcha.getResponse() != "" && */document.getElementById("faFormForename").checkValidity() && document.getElementById("faFormSurname").checkValidity() && document.getElementById("faFormEmail").checkValidity() && document.getElementById("faFormStreet").checkValidity() && document.getElementById("faFormZipCity").checkValidity())
    {
        $("#faForm").hide();
        $(".slide-form .description").hide();
        $(".slide-form .btn-usap").hide();
        $(".slide-form .description_upload").show();


        getCanvasBlob(canvas).then(function(blob)
        {
            var form = document.querySelector('#faForm')
            var fd = new FormData(form)
            fd.append('action','place_order');
            fd.append('voucher_token',VOUCHER_TOKEN);
            fd.append('image_blob', blob, 'filename.png');
            fd.append('api_key',SYSTEM_API_KEY );

            //console.log(fd);
            fetch("api.php",
            {
                method: "POST",
                body: fd
            }).then(function(response)
            {
                if (!response.ok)
                {
                    alert("Malheureusement, quelque chose n'a pas fonctionné. Veuillez cliquer à nouveau sur le bouton \"Je commande\" !")
                    $("#faForm").show();
                    $(".slide-form .description").show();
                    $(".slide-form .btn-usap").show();
                    $(".slide-form .description_upload").hide();

                } else {

                return response.json();

                }
            }).then((order_data) => {
                if(order_data.checkout_required == 1)
                {
                    init_payment_view(order_data);
                }
                else {
                    $('#viewCarousel').carousel(8);
                    $('#viewCarousel').carousel('pause');

                }

  }).catch(function(error) {
        console.log(error);
        alert("Malheureusement, quelque chose n'a pas fonctionné. Veuillez cliquer à nouveau sur le bouton \"Je commande\"! Sinon, vérifiez votre connexion Internet.")
        $("#faForm").show();
        $(".slide-form .description").show();
        $(".slide-form .btn-usap").show();
        $(".slide-form .description_upload").hide();
    });
        });
    } else
    {
        alert(
        'Merci de bien remplir tous les champs !',
        );
        $(".form-control[required], .g-recaptcha div").addClass("required");
    }
}

function stopStream() {
    if (!window.stream) return;

    window.stream.getAudioTracks().forEach(function(track) {
        track.stop();
    });

    window.stream.getVideoTracks().forEach(function(track) {
        track.stop();
    });

    window.stream = null;
}

function calculate_liveview()
{
    //const track = window.stream.getVideoTracks()[0];
    //const settings = track.getSettings();
    //const str = JSON.stringify(video_settings, null, 4);
    //console.log('settings ' + str);
    var window_width = $("body").width();
    var window_height = $("body").height();
    var window_ratio = window_height/window_width
    var maskTargetWidth, maskTargetHeight, maskTargetPositionX, maskTargetPositionY;
    $('#video_overlay').removeClass('landscape');
   if(window_ratio < mask_ratio)
   {
       maskTargetWidth = window_height/mask_ratio;
       maskTargetPositionX = (window_width-maskTargetWidth)/2;
       maskTargetHeight = window_height;
       maskTargetPositionY = 0;
      $(".spacer").css({width: (window_width-maskTargetWidth)*0.5, height: window_height});
       $('#video_overlay').addClass('landscape');
      // $("#video").css({width: "100%", height:"auto"});

   }
   else {
       maskTargetHeight = window_width*mask_ratio;
       maskTargetPositionY = (window_height-maskTargetHeight)/2;
       maskTargetWidth = window_width;
       maskTargetPositionX = 0;
       //$("#video").css({width: "auto", height:"100%"});

       $(".spacer").css({width: window_width,height: (window_height-maskTargetHeight)*0.5});
     //  $("#video").css({marginTop: (window_height-maskTargetHeight)*0.5});

   }

   var videoTargetWidth, videoTargetHeight, videoTargetPositionX, videoTargetPositionY;
   var video_ratio = video.videoHeight/video.videoWidth;
  if(video_ratio < mask_ratio)
  {
      videoTargetWidth = maskTargetHeight/video_ratio;
      videoTargetPositionX = (window_width-videoTargetWidth)/2;
      videoTargetHeight = maskTargetHeight;
      videoTargetPositionY = 0;
      $("#video").css({marginLeft: videoTargetPositionX,marginTop:(window_height-videoTargetHeight)*0.5});


  }
  else {
      videoTargetHeight = maskTargetWidth * video_ratio;
      videoTargetPositionY = (window_height-videoTargetHeight)/2;
      videoTargetWidth = maskTargetWidth;
      videoTargetPositionX = 0;

      $("#video").css({marginTop: videoTargetPositionY,marginLeft: (window_width-videoTargetWidth)*0.5});

  }
  $(".mask").css({maxWidth: maskTargetWidth,maxHeight: maskTargetHeight});

//$(".spacer").css({maxHeight: ($("body").height()-$("body").width()*mask_ratio)*0.25});
$("#video").css({width: videoTargetWidth, height: videoTargetHeight});

}

function detectmobilebrowser() {
  var userAgent = navigator.userAgent || navigator.vendor || window.opera;
  if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od|ad)|android|playbook|silk|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(userAgent) ||
      /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(userAgent.substr(0, 4)))
    return true;

  // Lying iOS13 iPad
  if (userAgent.match(/Macintosh/i) !== null) {
    // need to distinguish between Macbook and iPad
    var canvas = document.createElement("canvas");
    if (canvas !== null) {
      var context = canvas.getContext("webgl") || canvas.getContext("experimental-webgl");
      if (context) {
        var info = context.getExtension("WEBGL_debug_renderer_info");
        if (info) {
          var renderer = context.getParameter(info.UNMASKED_RENDERER_WEBGL);
          if (renderer.indexOf("Apple") !== -1)
            return true;
        }
      }
    }
  }

  return false;
}


function disclaimer_accept()
{
    var checkBox = document.getElementById("disclaimer_check");
    if (checkBox.checked == true){
        $('#viewCarousel').carousel('next');
        load_jsscript("https://www.google.com/recaptcha/api.js");
    } else {
        alert("Vous devez accepter les conditions pour continuer !");
    }

}

function load_jsscript(url)
{
  var jsscript = document.createElement("script");
  jsscript.async = true;
 jsscript.src = url;
  document.getElementsByTagName("head")[0].appendChild(jsscript, document.getElementsByTagName("head")[0]);

}
